// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000
// Print Pad Instructions and One Time Pads
//.........................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include "Tscmsg.h"
#include <htmlhelp.h>
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE	hInst;
extern	HWND		hMainWindow;
extern	LPTSTR		lpszNA;
extern	DWORD		Seed;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpOtpKeyIcon;
extern	LPCTSTR		lpszAppName;
extern	DWORD		Divisor1;
extern	BYTE		RingMask;
extern	LPTSTR		lpszHelpFile;
extern	DWORD		dwHelpTopicNumber;
extern	BOOL		bProcessInProgress;
extern	BOOL		bIsWinNT;
extern	HACCEL		hAccel;

// Help array for the controls in all of our dialog boxs.
//.......................................................
DWORD PadHelp[] =
{
	IDC_PADIDTEXT,		IDH_PADID,
	IDC_PADID,			IDH_PADID,
	IDC_PAGETEXT,		IDH_PAGES,
	IDC_PAGES,			IDH_PAGES,
	IDC_BUDDY1,			IDH_PAGES,
	IDC_USERIDTEXT,		IDH_USERID,
	IDC_USERID,			IDH_USERID,
	IDC_RSARESET,		IDH_RSARESET,
	IDC_COPY1TEXT,		IDH_ACTIVATE_VK,
	IDC_COPY1,			IDH_COPY1,
	IDC_COPY2TEXT,		IDH_ACTIVATE_VK,
	IDC_COPY2,			IDH_COPY2,
	IDC_FOREVER,		IDH_FOREVER,
	IDC_SETDAYS,		IDH_SETDAYS,
	IDC_VPTEXT,			IDH_VP,
	IDC_BUDDY4,			IDH_VP,
	IDC_VP,				IDH_VP,
	IDC_MODNTEXT,		IDH_MODN,
	IDC_BUDDY2,			IDH_MODN,
	IDC_MODN,			IDH_MODN,
	IDC_SEPARATIONTEXT,	IDH_SEPARATION,
	IDC_BUDDY3,			IDH_SEPARATION,
	IDC_SEPARATION,		IDH_SEPARATION,
	IDC_IDLE,			IDH_IDLE,
	IDC_NORMAL,			IDH_NORMAL,
	IDC_HIGH,			IDH_HIGH,
	IDC_REALTIME,		IDH_REALTIME,
	IDC_LOADED,			IDH_LOADED,
	IDC_LOAD,			IDH_LOAD,
	IDC_NEWRINGS,		IDH_NEWRINGS,
	IDC_MYHELP,			IDH_MYHELP,
	IDC_CHECKLOADED,	IDH_CHECKLOADED,
	IDC_CHECKLOADDIFF,	IDH_CHECKLOADDIFF,
	IDC_OLDPPTEXT,		IDH_ACTIVATE_VK,
	IDC_OLDPP,			IDH_OLDPP,
	IDC_CURRENTUIDTEXT,	IDH_CURRENTUID,
	IDC_CURRENTUID,		IDH_CURRENTUID,
	IDC_OWNERTEXT,		IDH_OWNER,
	IDC_OWNER,			IDH_OWNER,
	IDC_SETTINGTEXT,	IDH_SETTING,
	IDC_SETTING,		IDH_SETTING,
	IDC_DONTKNOW,		IDH_DONTKNOW,
	IDC_NO1,			IDH_NO1,
	IDC_USUALLY,		IDH_USUALLY,
	IDC_ALWAYS,			IDH_ALWAYS,
	IDC_SIGNUSERTEXT,	IDH_SIGNUSER,
	IDC_SIGNUSER,		IDH_SIGNUSER,
	IDC_NOID,			IDH_NOID,
	IDC_CASUALID,		IDH_CASUALID,
	IDC_POSITIVEID,		IDH_POSITIVEID,
	IDC_SKIPKEY,		IDH_SKIPKEY,
	IDC_OLDUSERIDTEXT,	IDH_OLDUSERID,
	IDC_OLDUSERID,		IDH_OLDUSERID,
	IDC_NEWUSERIDTEXT,	IDH_NEWUSERID,
	IDC_NEWUSERID,		IDH_NEWUSERID,
	IDC_REPEATTEXT,		IDH_REPEAT,
	IDC_BUDDY5,			IDH_REPEAT,
	IDC_REPEAT,			IDH_REPEAT,
	IDC_FINALTEXT,		IDH_FINAL,
	IDC_BUDDY6,			IDH_FINAL,
	IDC_FINAL,			IDH_FINAL,
	IDC_MARGINALSTEXT,	IDH_MARGINALS,
	IDC_BUDDY7,			IDH_MARGINALS,
	IDC_MARGINALS,		IDH_MARGINALS,
	IDC_COMPLETESTEXT,	IDH_COMPLETES,
	IDC_BUDDY8,			IDH_COMPLETES,
	IDC_COMPLETES,		IDH_COMPLETES,
	IDC_CONTAINS,		IDH_STATIC,
	IDC_ICON1,			IDH_STATIC,
	IDC_SIZE1,			IDH_STATIC,
	IDC_DATETIME1,		IDH_STATIC,
	IDC_ICON2,			IDH_STATIC,
	IDC_SIZE2,			IDH_STATIC,
	IDC_DATETIME2,		IDH_STATIC,
	IDC_MYYES,			IDH_MYYES,
	IDC_YESTOALL,		IDH_YESTOALL,
	IDC_MYNO,			IDH_MYNO,
	IDC_STATEMENT1,		IDH_STATIC,
	IDC_ATTRIBUTES,		IDH_STATIC,
	IDC_QUESTION1,		IDH_STATIC,
	IDC_MYYESC,			IDH_MYYESC,
	IDC_MYNOC,			IDH_MYNOC,
	IDC_YESTOALLC,		IDH_YESTOALLC,
	IDC_DRIVEICON,		IDH_STATIC,
	IDC_DESTINATION,	IDH_STATIC,
	IDC_OTPKEYFILES,	IDH_OTPKEYFILES,
	IDC_DATESUFFIX,		IDH_DATESUFFIX,
	IDC_NUMBERSUFFIX,	IDH_NUMBERSUFFIX,
	IDC_BASENAME,		IDH_BASENAME,
	IDC_DESTINATION1,	IDH_STATIC,
	IDC_SUBFOLDER,		IDH_SUBFOLDER,
	IDC_RECIPIENT,		IDH_STATIC,
	IDC_SESSIONKEY,		IDH_SESSIONKEY,
	IDC_OTPKEY,			IDH_OTPKEY,
	IDC_TRUEPAD,		IDH_TRUEPAD,
	IDC_MYYESDEC,		IDH_MYYESDEC,
	IDC_TRANSFORM1,		IDH_TRANSFORM1,
	IDC_TRANSFORM2,		IDH_TRANSFORM2,
	IDC_TRANSFORM3,		IDH_TRANSFORM3,
	IDC_TRANSFORM4,		IDH_TRANSFORM4,
	IDC_TRANSFORM5,		IDH_TRANSFORM5,
	IDC_TRANSFORM6,		IDH_TRANSFORM6,
	IDC_TRANSFORM7,		IDH_TRANSFORM7,
	IDC_14BITS,			IDH_14BITS,
	IDC_15BITS,			IDH_15BITS,
	IDC_16BITS,			IDH_16BITS,
	IDC_17BITS,			IDH_17BITS,
	IDC_18BITS,			IDH_18BITS,
	IDC_19BITS,			IDH_19BITS,
	IDC_20BITS,			IDH_20BITS,
	IDC_21BITS,			IDH_21BITS,
	IDC_22BITS,			IDH_22BITS,
	IDC_23BITS,			IDH_23BITS,
	IDC_24BITS,			IDH_24BITS,
	IDC_COMPRESSION,	IDH_COMPRESSION,
	IDC_BYTESSAVED,		IDH_BYTESSAVED,
	IDC_ORIGINALSIZE,	IDH_ORIGINALSIZE,
	IDC_PACKEDSIZE,		IDH_PACKEDSIZE,
	IDC_PACKEDFILES,	IDH_PACKEDFILES,
	IDC_REGNAME,		IDH_REGNAME,
	IDC_REGNAME1,		IDH_REGNAME,
	IDC_REGNUMBER,		IDH_REGNUMBER,
	IDC_REGNUMBER1,		IDH_REGNUMBER,
	IDC_MAXSIZE,		IDH_MAXSIZE,
	IDC_TSCLOGO,		IDH_TSCLOGO,
	IDC_MYYESXFORM,		IDH_MYYESXFORM,
	IDC_PLAYSOUNDS,		IDH_PLAYSOUNDS,
	IDC_LEFTALIGN,		IDH_LEFTALIGN,
	IDC_SAVERINGS,		IDH_SAVERINGS,
	IDC_REGISTER1,		IDH_REGISTER1,
	IDC_WIPEAFTERUSE,	IDH_WIPEAFTERUSE,
	IDC_MEGABYTES,		IDH_MEGABYTES,
	IDC_RDTSC,			IDH_RDTSC,
	IDC_SPECIAL,		IDH_SPECIAL,
	IDC_RTF,			IDH_RTF,
	IDC_HTML,			IDH_HTML,
	IDC_ES,				IDH_ES,
	IDC_NATIVE,			IDH_NATIVE,
	IDC_TEXT,			IDH_TEXT,
	IDC_OEM,			IDH_OEM,
	IDC_UNICODE,		IDH_UNICODE,
	IDC_DIB,			IDH_DIB,
	IDC_TOTEXT,			IDH_TO,
	IDC_TO,				IDH_TO,
	IDC_CCTEXT,			IDH_CC,
	IDC_CC,				IDH_CC,
	IDC_BCCTEXT,		IDH_BCC,
	IDC_BCC,			IDH_BCC,
	IDC_SUBTEXT,		IDH_SUBJECT,
	IDC_SUBJECT,		IDH_SUBJECT,
	IDC_ATTACHTEXT,		IDH_ATTACHMENT,
	IDC_ATTACHMENT,		IDH_ATTACHMENT,
	IDC_NOTE,			IDH_NOTE,
	IDC_BOLD,			IDH_BOLD,
	IDC_ITALIC,			IDH_ITALIC,
	IDC_UNDERLINE,		IDH_UNDERLINE,
	IDC_LEFT,			IDH_LEFT,
	IDC_CENTER,			IDH_CENTER,
	IDC_RIGHT,			IDH_RIGHT,
	IDC_BULLETS,		IDH_BULLETS,
	IDC_RETURN,			IDH_RETURN,
	IDC_FONT,			IDH_FONT,
	IDC_BKG,			IDH_BKG,
	IDC_TEXTCLR,		IDH_TEXTCLR,
	IDC_RESOLVE,		IDH_RESOLVE,
	IDC_ATTACH,			IDH_ATTACH,
	IDC_MSGENCRYPT,		IDH_MSGENCRYPT,
	IDC_ADDRBOOK,		IDH_ADDRBOOK,
	IDC_MSGLIST,		IDH_MSGLIST,
	IDC_READMSG,		IDH_READMSG,
	IDC_DELETEMSG,		IDH_DELETEMSG,
	IDC_UNDELETEMSG,	IDH_UNDELETEMSG,
	IDC_MYCLOSE,		IDH_MYCLOSE,
	IDC_RFROMTEXT,		IDH_RFROM,
	IDC_RFROM,			IDH_RFROM,
	IDC_RDATETEXT,		IDH_RDATE,
	IDC_RDATE,			IDH_RDATE,
	IDC_RTOTEXT,		IDH_RTO,
	IDC_RTO,			IDH_RTO,
	IDC_RCCTEXT,		IDH_RCC,
	IDC_RCC,			IDH_RCC,
	IDC_RATTACHTEXT,	IDH_RATTACHMENT,
	IDC_RATTACHMENT,	IDH_RATTACHMENT,
	IDC_RNOTE,			IDH_RNOTE,
	IDC_RDECRYPT,		IDH_RDECRYPT,
	IDC_SAVEATTACH,		IDH_SAVEATTACH,
	IDC_REPLY,			IDH_REPLY,
	IDC_REPLYALL,		IDH_REPLYALL,
	IDC_FORWARD,		IDH_FORWARD,
	IDC_RSUBJECTEXT,	IDH_RSUBJECT,
	IDC_RSUBJECT,		IDH_RSUBJECT,
	IDC_ASKMAPIEDIT,	IDH_STATIC,
	IDC_MAPIYES,		IDH_MAPIYES,
	IDC_MAPINO,			IDH_MAPINO,
	IDC_ASKMAPI,		IDH_STATIC,
	IDC_WIPEAFTERENC,	IDH_WIPEAFTERENC,
	IDC_WIPEAFTERPACK,	IDH_WIPEAFTERPACK,
	IDC_WIPEAFTERDEC,	IDH_WIPEAFTERDEC,
	IDC_WIPEOTPKEYFILE,	IDH_WIPEOTPKEYFILE,
	IDC_WIPETRUEOTP,	IDH_WIPETRUEOTP,
	IDC_WIPEPACKEDFILE,	IDH_WIPEPACKEDFILE,
	IDC_WIPEAFTERXFORM,	IDH_WIPEAFTERXFORM,
	IDC_WIPEAFTEREXTR,	IDH_WIPEAFTEREXTR,
	IDC_REGISTER2,		IDH_REGISTER2,
	IDC_EVAL,			IDH_EVAL,
	IDC_ENTERCODES,		IDH_ENTERCODES,
	IDC_MYEXIT,			IDH_MYEXIT,
	IDC_BROWSE,			IDH_BROWSE,
	IDC_OPEN_ENCR,		IDH_OPEN_ENCR,
	IDC_OPEN_ENCR1,		IDH_OPEN_ENCR,
	IDC_COMPANDENC,		IDH_COMPANDENC,
	IDC_WIPEAFTERATTACH,IDH_WIPEAFTERATTACH,
	IDC_WIPEINTERPKD,	IDH_WIPEINTERPKD,
	IDC_NEWBIE_HELP,	IDH_STATIC,
	IDC_ADMINNAMETEXT,	IDH_ACTIVATE_VK,
	IDC_ADMINNAME,		IDH_ADMINNAME,
	IDC_PPTEXT1,		IDH_ACTIVATE_VK,
	IDC_PP1,			IDH_PP1,
	IDC_PPTEXT2,		IDH_ACTIVATE_VK,
	IDC_PP2,			IDH_PP2,
	IDC_ADMINCLEAR,		IDH_ADMINCLEAR,
	IDC_REMAINSIGNEDIN,	IDH_REMAINSIGNEDIN,
	IDC_ADMINNSITEXT,	IDH_ACTIVATE_VK,
	IDC_ADMINNSI,		IDH_ADMINNSI,
	IDC_PPSITEXT,		IDH_ACTIVATE_VK,
	IDC_PPSI,			IDH_PPSI,
	IDC_A_WIPE,			IDH_A_WIPE,
	IDC_A_DELETE,		IDH_A_DELETE,
	IDC_A_REPEAT,		IDH_A_REPEAT,
	IDC_A_MARGINALS,	IDH_A_MARGINALS,
	IDC_A_COMPLETES,	IDH_A_COMPLETES,
	IDC_A_TRUE,			IDH_A_TRUE,
	IDC_A_CREATE,		IDH_A_CREATE,
	IDC_A_CREATE_TOTP,	IDH_A_CREATE_TOTP,
	IDC_A_VIEW_TOTP,	IDH_A_VIEW_TOTP,
	IDC_A_P_DELETE_K,	IDH_A_P_DELETE_K,
	IDC_A_P_DELETE_S,	IDH_A_P_DELETE_S,
	IDC_A_P_SIGN,		IDH_A_P_SIGN,
	IDC_A_P_EXTRACT,	IDH_A_P_EXTRACT,
	IDC_A_P_VIEW,		IDH_A_P_VIEW,
	IDC_A_P_DISABLE,	IDH_A_P_DISABLE,
	IDC_A_S_VIEW,		IDH_A_S_VIEW,
	IDC_A_S_COMPONENTS,	IDH_A_S_COMPONENTS,
	IDC_A_S_DELETE,		IDH_A_S_DELETE,
	IDC_A_S_CHANGE,		IDH_A_S_CHANGE,
	IDC_A_S_EXTRACT,	IDH_A_S_EXTRACT,
	IDC_A_S_ID,			IDH_A_S_ID,
	IDC_A_P_OWNER,		IDH_A_P_OWNER,
	IDC_A_S_COMPROMISE,	IDH_A_S_COMPROMISE,
	IDC_DONOTASKAGAIN,	IDH_STATIC,
	IDC_PWYES,			IDH_PWYES,
	IDC_PWNO,			IDH_PWNO,
	IDC_PPTSCGTEXT,		IDH_ACTIVATE_VK,
	IDC_PPTSCG,			IDH_PPTSCG,
	IDC_PPTSCGCLEAR,	IDH_PPTSCGCLEAR,
	IDC_PPTSCGTEXT1,	IDH_ACTIVATE_VK,
	IDC_PPTSCG1,		IDH_PPTSCG1,
	IDC_ABCCAP,			IDH_ABCCAP,
	IDC_ABCSMALL,		IDH_ABCSMALL,
	IDC_MATH,			IDH_MATH,
	IDC_SYMBOLS,		IDH_SYMBOLS,
	IDC_BACKSPACE,		IDH_BACKSPACE,
	IDC_CLEAR,			IDH_CLEAR,
	IDC_INTERNATIONAL,	IDH_INTERNATIONAL,
	IDC_INTERNATIONAL1,	IDH_INTERNATIONAL1,
	IDC_VK11,			IDH_VK_KEYS,
	IDC_VK12,			IDH_VK_KEYS,
	IDC_VK13,			IDH_VK_KEYS,
	IDC_VK14,			IDH_VK_KEYS,
	IDC_VK15,			IDH_VK_KEYS,
	IDC_VK16,			IDH_VK_KEYS,
	IDC_VK17,			IDH_VK_KEYS,
	IDC_VK18,			IDH_VK_KEYS,
	IDC_VK19,			IDH_VK_KEYS,
	IDC_VK21,			IDH_VK_KEYS,
	IDC_VK22,			IDH_VK_KEYS,
	IDC_VK23,			IDH_VK_KEYS,
	IDC_VK24,			IDH_VK_KEYS,
	IDC_VK25,			IDH_VK_KEYS,
	IDC_VK26,			IDH_VK_KEYS,
	IDC_VK27,			IDH_VK_KEYS,
	IDC_VK28,			IDH_VK_KEYS,
	IDC_VK29,			IDH_VK_KEYS,
	IDC_VK31,			IDH_VK_KEYS,
	IDC_VK32,			IDH_VK_KEYS,
	IDC_VK33,			IDH_VK_KEYS,
	IDC_VK34,			IDH_VK_KEYS,
	IDC_VK35,			IDH_VK_KEYS,
	IDC_VK36,			IDH_VK_KEYS,
	IDC_VK37,			IDH_VK_KEYS,
	IDC_VK38,			IDH_VK_KEYS,
	IDC_VK39,			IDH_VK_KEYS,
	IDC_CLEARPP,		IDH_CLEARPP,
	IDC_CLEARPP1,		IDH_CLEARPP1,
	IDC_SERVER1,		IDH_SERVERS,
	IDC_SERVER2,		IDH_SERVERS,
	IDC_SERVER3,		IDH_SERVERS,
	IDC_SERVER4,		IDH_SERVERS,
	IDC_SERVER5,		IDH_SERVERS,
	IDC_SERVER6,		IDH_SERVERS,
	IDC_SERVER7,		IDH_SERVERS,
	IDC_SERVER8,		IDH_SERVERS,
	IDC_SERVER9,		IDH_SERVERS,
	IDC_TEXTOUT,		IDH_STATIC,
	IDC_SET_TIME,		IDH_SET_TIME,
	IDC_B1,				IDH_STATIC,
	IDC_B2,				IDH_STATIC,
	IDC_B3,				IDH_STATIC,
	IDC_B4,				IDH_STATIC,
	IDC_B5,				IDH_STATIC,
	IDC_B6,				IDH_STATIC,
	IDC_B7,				IDH_STATIC,
	IDC_B8,				IDH_STATIC,
	IDC_B9,				IDH_STATIC,
	IDC_B10,			IDH_STATIC,
	IDC_START_TEXT,		IDH_START_INDENT,
	IDC_START_INDENT,	IDH_START_INDENT,
	IDC_SEQ_TEXT,		IDH_SEQ_INDENT,
	IDC_SEQ_INDENT,		IDH_SEQ_INDENT,
	IDC_RIGHT_TEXT,		IDH_RIGHT_INDENT,
	IDC_RIGHT_INDENT,	IDH_RIGHT_INDENT,
	IDC_SPACEBEFORE_TXT,IDH_SPACEBEFORE,
	IDC_SPACEBEFORE,	IDH_SPACEBEFORE,
	IDC_SPACEAFTER_TXT,	IDH_SPACEAFTER,
	IDC_SPACEAFTER,		IDH_SPACEAFTER,
	IDC_SPACE1,			IDH_SPACE1,
	IDC_SPACE2,			IDH_SPACE2,
	IDC_SPACE3,			IDH_SPACE3,
	IDC_SPACE4,			IDH_SPACE4,
	IDC_SPECIFY_TEXT,	IDH_SPECIFY,
	IDC_SPECIFY,		IDH_SPECIFY,
	IDC_SPACE_B_TEXT,	IDH_SPACE_B,
	IDC_SPACE_B,		IDH_SPACE_B,
	IDC_DATETIMELIST,	IDH_STATIC,
	IDC_EMAILFROM,		IDH_STATIC,
	IDC_EMAILSUB,		IDH_STATIC,
	IDC_EMAILREC,		IDH_STATIC,
	IDC_MYYESE,			IDH_MYYESE,
	IDC_YESTOALLE,		IDH_YESTOALLE,
	IDC_MYNOE,			IDH_MYNOE,
	IDC_TIPEDIT,		IDH_STATIC,
	IDC_TIPASK,			IDH_STATIC,
	IDC_ISP_TEXT,		IDH_ISP,
	IDC_ISP,			IDH_ISP,
	IDC_NICKNAME_TEXT,	IDH_NICKNAME,
	IDC_NICKNAME,		IDH_NICKNAME,
	IDC_CHAT1,			IDH_CHAT1,
	IDC_CHAT2,			IDH_CHAT2,
	IDC_CHAT3,			IDH_CHAT3,
	IDC_DIAL,			IDH_DIAL,
	IDC_NOTIFY,			IDH_NOTIFY,
	IDC_CONNECT,		IDH_CONNECT,
	IDC_DISPLAY,		IDH_DISPLAY,
	IDC_ENDCHAT,		IDH_ENDCHAT,
	IDC_CHAT_CLOSE,		IDH_CHAT_CLOSE,
	IDC_SEND,			IDH_SEND,
	IDC_SAVE_CHAT,		IDH_SAVE_CHAT,
	IDC_A_NOTES,		IDH_A_NOTES,
	IDC_A_CHAT,			IDH_A_CHAT,
	IDC_SENDFONT,		IDH_SENDFONT,
	IDC_SENDTXTCLR,		IDH_SENDTXTCLR,
	IDC_TOPPANEL,		IDH_TOPPANEL,
	IDC_MIDDLEPANEL,	IDH_MIDDLEPANEL,
	IDC_BOTTOMPANEL,	IDH_BOTTOMPANEL,
	IDC_FKEY_IDT,		IDH_FKEY_ID,
	IDC_FKEY_ID,		IDH_FKEY_ID,
	IDC_FKEY_STARTT,	IDH_FKEY_START,
	IDC_FKEY_START,		IDH_FKEY_START,
	IDC_FKEY_TYPET,		IDH_FKEY_TYPE,
	IDC_FKEY_TYPE,		IDH_FKEY_TYPE,
	IDC_FKEY_SIZET,		IDH_FKEY_SIZE,
	IDC_FKEY_SIZE,		IDH_FKEY_SIZE,
	IDC_FKEY_CREATEDT,	IDH_FKEY_CREATED,
	IDC_FKEY_CREATED,	IDH_FKEY_CREATED,
	IDC_FKEY_EXPIRET,	IDH_FKEY_EXPIRE,
	IDC_FKEY_EXPIRE,	IDH_FKEY_EXPIRE,
	IDC_FKEY_MD5T,		IDH_FKEY_MD5,
	IDC_FKEY_MD5,		IDH_FKEY_MD5,
	IDC_MD5_FP,			IDH_MD5_FP,
	IDC_FKEY_SHAT,		IDH_FKEY_SHA,
	IDC_FKEY_SHA,		IDH_FKEY_SHA,
	IDC_SHA_FP,			IDH_SHA_FP,
	IDC_SIGTOFILE,		IDH_SIGTOFILE,
	IDC_SIGTOCLIP,		IDH_SIGTOCLIP,
	IDC_SIGTEXT,		IDH_SIGTEXT,
	IDC_SIGN_CLIPBOARD,	IDH_SIGN_CLIPBOARD,
	IDC_SIGN_ID,		IDH_STATIC,
	IDC_SIG_FILE1,		IDH_STATIC,
	IDC_SIG_FILE2,		IDH_STATIC,
	IDC_SIG_ID,			IDH_STATIC,
	IDC_SIG_DIGEST,		IDH_STATIC,
	IDC_SIG_DATA,		IDH_STATIC,
	IDC_FILE_DIGEST,	IDH_STATIC,
	IDC_FILE_DATA,		IDH_STATIC,
	IDC_SIG_RESULT,		IDH_STATIC,
	IDC_SIG_CREATED,	IDH_STATIC,
	IDC_SPELLCHECK,		IDH_SPELLCHECK,
	IDC_DIARYNAMETEXT,	IDH_DIARYNAME,
	IDC_DIARYNAME,		IDH_DIARYNAME,
	IDC_DIARYPP1,		IDH_DIARYPP1,
	IDC_DIARYCLEAR,		IDH_DIARYCLEAR,
	IDC_PPTDIARY,		IDH_PPTDIARY,
	IDC_DIARY,			IDH_STATIC,
	IDC_ADMINCODEPP1,	IDH_ADMINCODEPP1,
	IDC_ADMINCODEPP2,	IDH_ADMINCODEPP2,
	IDC_ADMINCODECLEAR,	IDH_ADMINCODECLEAR,
	IDC_ADMINCODEDIARY,	IDH_ADMINCODEDIARY,
	IDC_MAKEPERMANENT,	IDH_MAKEPERMANENT,
	IDC_PAGECREATED,	IDH_STATIC,
	IDC_PAGEMODIFIED,	IDH_STATIC,
	IDC_DIARYTREE,		IDH_STATIC,
	IDC_DIARYNOTE,		IDH_STATIC,
	IDC_KW1,			IDH_KW,
	IDC_KW2,			IDH_KW,
	IDC_KW3,			IDH_KW,
	IDC_KW4,			IDH_KW,
	IDC_KW5,			IDH_KW,
	IDC_KW6,			IDH_KW,
	IDC_NEWPAGE,		IDH_NEWPAGE,
	IDC_CLEARPAGE,		IDH_CLEARPAGE,
	IDC_SAVEPAGE,		IDH_SAVEPAGE,
	IDC_MAILPAGE,		IDH_MAILPAGE,
	IDC_OLDCODES,		IDH_OLDCODES,
	IDC_PAGEDELETE,		IDH_PAGEDELETE,
	IDC_PAGEUNDELETE,	IDH_PAGEUNDELETE,
	IDC_MARK,			IDH_STATIC,
	IDC_CLIENTISP,		IDH_CLIENTISP,
	IDC_CLIENTISPTXT,	IDH_CLIENTISP,
	IDC_CHAT_SPELL,		IDH_CHAT_SPELL,
	IDC_PUTSPECIAL,		IDH_PUTSPECIAL,
	IDC_USEGMT,			IDH_USEGMT,
	IDC_SL,				IDH_SL,
	IDC_UL,				IDH_UL,
	IDC_DISCOUNT,		IDH_STATIC,
	IDC_MYIPTEXT,		IDH_MYIP,
	IDC_MYIP,			IDH_MYIP,
	IDC_DELETEIP,		IDH_DELETEIP,
	IDC_SMILEY1,		IDH_SMILEY,
	IDC_SMILEY2,		IDH_SMILEY,
	IDC_SMILEY3,		IDH_SMILEY,
	IDC_SMILEY4,		IDH_SMILEY,
	IDC_SMILEY5,		IDH_SMILEY,
	IDC_SMILEY6,		IDH_SMILEY,
	IDC_SMILEY7,		IDH_SMILEY,
	IDC_SMILEY8,		IDH_SMILEY,
	IDC_SMILEY9,		IDH_SMILEY,
	IDC_SMILEY10,		IDH_SMILEY,
	IDC_SMILEY11,		IDH_SMILEY,
	IDC_SMILEY12,		IDH_SMILEY,
	IDC_SMILEY13,		IDH_SMILEY,
	IDC_SMILEY14,		IDH_SMILEY,
	IDC_SMILEY15,		IDH_SMILEY,
	IDC_SMILEY16,		IDH_SMILEY,
	IDC_SMILEY17,		IDH_SMILEY,
	IDC_SMILEY18,		IDH_SMILEY,
	IDC_SMILEY19,		IDH_SMILEY,
	IDC_SMILEY20,		IDH_SMILEY,
	IDC_SMILEY21,		IDH_SMILEY,
	IDC_SMILEY22,		IDH_SMILEY,
	IDC_SMILEY23,		IDH_SMILEY,
	IDC_SMILEY24,		IDH_SMILEY,
	IDC_SMILEY25,		IDH_SMILEY,
	IDC_SMILEY26,		IDH_SMILEY,
	IDC_SMILEY27,		IDH_SMILEY,
	IDC_SMILEY28,		IDH_SMILEY,
	IDC_SMILEY29,		IDH_SMILEY,
	IDC_SMILEY30,		IDH_SMILEY,
	IDC_SMILEY31,		IDH_SMILEY,
	IDC_SMILEY32,		IDH_SMILEY,
	IDC_SMILEY33,		IDH_SMILEY,
	IDC_SMILEY34,		IDH_SMILEY,
	IDC_SMILEY35,		IDH_SMILEY,
	IDC_SMILEY36,		IDH_SMILEY,
	IDC_SMILEY37,		IDH_SMILEY,
	IDC_SMILEY38,		IDH_SMILEY,
	IDC_SMILEY39,		IDH_SMILEY,
	IDC_SMILEY40,		IDH_SMILEY,
	IDC_SMILEY41,		IDH_SMILEY,
	IDC_SMILEY42,		IDH_SMILEY,
	IDC_SMILEY43,		IDH_SMILEY,
	IDC_SMILEY44,		IDH_SMILEY,
	IDC_SMILEY45,		IDH_SMILEY,
	IDC_SMILEY46,		IDH_SMILEY,
	IDC_SMILEY47,		IDH_SMILEY,
	IDC_SMILEY48,		IDH_SMILEY,
	IDC_SMILEY49,		IDH_SMILEY,
	IDC_SMILEY50,		IDH_SMILEY,
	IDC_SMILEY51,		IDH_SMILEY,
	IDC_SMILEY52,		IDH_SMILEY,
	IDC_SMILEY53,		IDH_SMILEY,
	IDC_SMILEY54,		IDH_SMILEY,
	IDC_SMILEY55,		IDH_SMILEY,
	IDC_SMILEY56,		IDH_SMILEY,
	IDC_SMILEY57,		IDH_SMILEY,
	IDC_SMILEY58,		IDH_SMILEY,
	IDC_SMILEY59,		IDH_SMILEY,
	IDC_SMILEY60,		IDH_SMILEY,
	
	IDC_SMILEY61,		IDH_SMILEY,
	IDC_SMILEY62,		IDH_SMILEY,
	IDC_SMILEY63,		IDH_SMILEY,
	IDC_SMILEY64,		IDH_SMILEY,
	IDC_SMILEY65,		IDH_SMILEY,
	IDC_SMILEY66,		IDH_SMILEY,
	IDC_SMILEY67,		IDH_SMILEY,
	IDC_SMILEY68,		IDH_SMILEY,
	IDC_SMILEY69,		IDH_SMILEY,
	IDC_SMILEY70,		IDH_SMILEY,
	IDC_SMILEY71,		IDH_SMILEY,
	IDC_SMILEY72,		IDH_SMILEY,
	IDC_SMILEY73,		IDH_SMILEY,
	IDC_SMILEY74,		IDH_SMILEY,
	IDC_SMILEY75,		IDH_SMILEY,
	IDC_SMILEY76,		IDH_SMILEY,
	IDC_SMILEY77,		IDH_SMILEY,
	IDC_SMILEY78,		IDH_SMILEY,
	IDC_SMILEY79,		IDH_SMILEY,
	IDC_SMILEY80,		IDH_SMILEY,
	IDC_SMILEY81,		IDH_SMILEY,
	IDC_SMILEY82,		IDH_SMILEY,
	IDC_SMILEY83,		IDH_SMILEY,
	IDC_SMILEY84,		IDH_SMILEY,
	IDC_SMILEY85,		IDH_SMILEY,
	IDC_SMILEY86,		IDH_SMILEY,
	IDC_SMILEY87,		IDH_SMILEY,
	IDC_SMILEY88,		IDH_SMILEY,
	IDC_SMILEY89,		IDH_SMILEY,
	IDC_SMILEY90,		IDH_SMILEY,
	IDC_SMILEY91,		IDH_SMILEY,
	IDC_SMILEY92,		IDH_SMILEY,
	IDC_SMILEY93,		IDH_SMILEY,
	IDC_SMILEY94,		IDH_SMILEY,
	IDC_SMILEY95,		IDH_SMILEY,
	IDC_SMILEY96,		IDH_SMILEY,
	IDC_SMILEY97,		IDH_SMILEY,
	IDC_SMILEY98,		IDH_SMILEY,
	IDC_SMILEY99,		IDH_SMILEY,
	IDC_SMILEY100,		IDH_SMILEY,
	IDC_SMILEY101,		IDH_SMILEY,
	IDC_SMILEY102,		IDH_SMILEY,
	IDC_SMILEY103,		IDH_SMILEY,
	IDC_SMILEY104,		IDH_SMILEY,
	IDC_SMILEY105,		IDH_SMILEY,
	IDC_SMILEY106,		IDH_SMILEY,
	IDC_SMILEY107,		IDH_SMILEY,
	IDC_SMILEY108,		IDH_SMILEY,
	IDC_SMILEY109,		IDH_SMILEY,
	IDC_SMILEY110,		IDH_SMILEY,
	IDC_SMILEY111,		IDH_SMILEY,
	IDC_SMILEY112,		IDH_SMILEY,
	IDC_SMILEY113,		IDH_SMILEY,
	IDC_SMILEY114,		IDH_SMILEY,
	IDC_SMILEY115,		IDH_SMILEY,
	IDC_SMILEY116,		IDH_SMILEY,
	IDC_SMILEY117,		IDH_SMILEY,
	IDC_SMILEY118,		IDH_SMILEY,
	IDC_SMILEY119,		IDH_SMILEY,
	IDC_SMILEY120,		IDH_SMILEY,

	IDC_SMILEY121,		IDH_SMILEY,
	IDC_SMILEY122,		IDH_SMILEY,
	IDC_SMILEY123,		IDH_SMILEY,
	IDC_SMILEY124,		IDH_SMILEY,
	IDC_SMILEY125,		IDH_SMILEY,
	IDC_SMILEY126,		IDH_SMILEY,
	IDC_SMILEY127,		IDH_SMILEY,
	IDC_SMILEY128,		IDH_SMILEY,
	IDC_SMILEY129,		IDH_SMILEY,
	IDC_SMILEY130,		IDH_SMILEY,
	IDC_SMILEY131,		IDH_SMILEY,
	IDC_SMILEY132,		IDH_SMILEY,
	IDC_SMILEY133,		IDH_SMILEY,
	IDC_SMILEY134,		IDH_SMILEY,
	IDC_SMILEY135,		IDH_SMILEY,
	IDC_SMILEY136,		IDH_SMILEY,
	IDC_SMILEY137,		IDH_SMILEY,
	IDC_SMILEY138,		IDH_SMILEY,
	IDC_SMILEY139,		IDH_SMILEY,
	IDC_SMILEY140,		IDH_SMILEY,
	IDC_SMILEY141,		IDH_SMILEY,
	IDC_SMILEY142,		IDH_SMILEY,
	IDC_SMILEY143,		IDH_SMILEY,
	IDC_SMILEY144,		IDH_SMILEY,
	IDC_SMILEY145,		IDH_SMILEY,
	IDC_SMILEY146,		IDH_SMILEY,
	IDC_SMILEY147,		IDH_SMILEY,
	IDC_SMILEY148,		IDH_SMILEY,
	IDC_SMILEY149,		IDH_SMILEY,
	IDC_SMILEY150,		IDH_SMILEY,
	IDC_SMILEY151,		IDH_SMILEY,
	IDC_SMILEY152,		IDH_SMILEY,
	IDC_SMILEY153,		IDH_SMILEY,
	IDC_SMILEY154,		IDH_SMILEY,
	IDC_SMILEY155,		IDH_SMILEY,
	IDC_SMILEY156,		IDH_SMILEY,
	IDC_SMILEY157,		IDH_SMILEY,
	IDC_SMILEY158,		IDH_SMILEY,
	IDC_SMILEY159,		IDH_SMILEY,
	IDC_SMILEY160,		IDH_SMILEY,
	IDC_SMILEY161,		IDH_SMILEY,
	IDC_SMILEY162,		IDH_SMILEY,
	IDC_SMILEY163,		IDH_SMILEY,
	IDC_SMILEY164,		IDH_SMILEY,
	IDC_SMILEY165,		IDH_SMILEY,
	IDC_SMILEY166,		IDH_SMILEY,
	IDC_SMILEY167,		IDH_SMILEY,
	IDC_SMILEY168,		IDH_SMILEY,
	IDC_SMILEY169,		IDH_SMILEY,
	IDC_SMILEY170,		IDH_SMILEY,
	IDC_SMILEY171,		IDH_SMILEY,
	IDC_SMILEY172,		IDH_SMILEY,
	IDC_SMILEY173,		IDH_SMILEY,
	IDC_SMILEY174,		IDH_SMILEY,
	IDC_SMILEY175,		IDH_SMILEY,
	IDC_SMILEY176,		IDH_SMILEY,
	IDC_SMILEY177,		IDH_SMILEY,
	IDC_SMILEY178,		IDH_SMILEY,
	IDC_SMILEY179,		IDH_SMILEY,
	IDC_SMILEY180,		IDH_SMILEY,
	IDC_MYCLOSE1,		IDH_MYCLOSE1,
	IDC_CHAT_SMILEY,	IDH_CHAT_SMILEY,
	IDC_SKIP,			IDH_SKIP,
	IDC_USE_ENC_FOLDER,	IDH_USE_ENC_FOLDER,
	IDC_TIME_CANCEL,	IDH_TIME_CANCEL,
	IDC_SMILEYSCLIP,	IDH_SMILEYSCLIP,
	IDC_FORMATCLIP,		IDH_FORMATCLIP,
	IDC_DATECLIP,		IDH_DATECLIP,
	IDC_TTIPTITLE,		IDH_TTIPTITLE,
	IDC_ULALL,			IDH_ULALL,
	IDC_ULDOTTED,		IDH_ULDOTTED,
	IDC_ULDASH,			IDH_ULDASH,
	IDC_ULDASHDOT,		IDH_ULDASHDOT,
	IDC_ULDASHDOTDOT,	IDH_ULDASHDOTDOT,
	IDC_ULWAVE,			IDH_ULWAVE,
	IDC_SIG_DATA1,		IDH_STATIC,
	IDC_FILE_DATA1,		IDH_STATIC,
	IDC_STATIC,			IDH_STATIC,
	0,0
};

LPDWORD		lpdwPadHelp = PadHelp;

// Pointer to help file for context sensitive help.
//.................................................
TCHAR		szCSHelp[] = "TscHelp.chm::/Context/Context.txt";
TCHAR		szMyCSHelp[512];
LPCSTR		lpContextHelp = szMyCSHelp;
LPCSTR		lpContextCalc = szCSHelp;

// Strings for the One Time Pad Instructions.
//...........................................
TCHAR Pad1[]  = "   Vigenere Tableau                                   Top Secret Crypto Gold";
TCHAR Pad2[]  = "               A B C D E F G H I J K L M N O P Q R S T U V W X Y Z -";
TCHAR Pad3[]  = "              -------------------------------------------------------";

TCHAR Pad4[]  = "            A |A B C|D E F|G H I|J K L|M N O|P Q R|S T U|V W X|Y Z -|";
TCHAR Pad5[]  = "            B |B C D|E F G|H I J|K L M|N O P|Q R S|T U V|W X Y|Z - A|";
TCHAR Pad6[]  = "            C |C D E|F G H|I J K|L M N|O P Q|R S T|U V W|X Y Z|- A B|";

TCHAR Pad7[]  = "            D |D E F|G H I|J K L|M N O|P Q R|S T U|V W X|Y Z -|A B C|";
TCHAR Pad8[]  = "            E |E F G|H I J|K L M|N O P|Q R S|T U V|W X Y|Z - A|B C D|";
TCHAR Pad9[]  = "            F |F G H|I J K|L M N|O P Q|R S T|U V W|X Y Z|- A B|C D E|";

TCHAR Pad10[] = "            G |G H I|J K L|M N O|P Q R|S T U|V W X|Y Z -|A B C|D E F|";
TCHAR Pad11[] = "            H |H I J|K L M|N O P|Q R S|T U V|W X Y|Z - A|B C D|E F G|";
TCHAR Pad12[] = "            I |I J K|L M N|O P Q|R S T|U V W|X Y Z|- A B|C D E|F G H|";

TCHAR Pad13[] = "            J |J K L|M N O|P Q R|S T U|V W X|Y Z -|A B C|D E F|G H I|";
TCHAR Pad14[] = "            K |K L M|N O P|Q R S|T U V|W X Y|Z - A|B C D|E F G|H I J|";
TCHAR Pad15[] = "            L |L M N|O P Q|R S T|U V W|X Y Z|- A B|C D E|F G H|I J K|";

TCHAR Pad16[] = "            M |M N O|P Q R|S T U|V W X|Y Z -|A B C|D E F|G H I|J K L|";
TCHAR Pad17[] = "            N |N O P|Q R S|T U V|W X Y|Z - A|B C D|E F G|H I J|K L M|";
TCHAR Pad18[] = "            O |O P Q|R S T|U V W|X Y Z|- A B|C D E|F G H|I J K|L M N|";

TCHAR Pad19[] = "            P |P Q R|S T U|V W X|Y Z -|A B C|D E F|G H I|J K L|M N O|";
TCHAR Pad20[] = "            Q |Q R S|T U V|W X Y|Z - A|B C D|E F G|H I J|K L M|N O P|";
TCHAR Pad21[] = "            R |R S T|U V W|X Y Z|- A B|C D E|F G H|I J K|L M N|O P Q|";

TCHAR Pad22[] = "            S |S T U|V W X|Y Z -|A B C|D E F|G H I|J K L|M N O|P Q R|";
TCHAR Pad23[] = "            T |T U V|W X Y|Z - A|B C D|E F G|H I J|K L M|N O P|Q R S|";
TCHAR Pad24[] = "            U |U V W|X Y Z|- A B|C D E|F G H|I J K|L M N|O P Q|R S T|";

TCHAR Pad25[] = "            V |V W X|Y Z -|A B C|D E F|G H I|J K L|M N O|P Q R|S T U|";
TCHAR Pad26[] = "            W |W X Y|Z - A|B C D|E F G|H I J|K L M|N O P|Q R S|T U V|";
TCHAR Pad27[] = "            X |X Y Z|- A B|C D E|F G H|I J K|L M N|O P Q|R S T|U V W|";

TCHAR Pad28[] = "            Y |Y Z -|A B C|D E F|G H I|J K L|M N O|P Q R|S T U|V W X|";
TCHAR Pad29[] = "            Z |Z - A|B C D|E F G|H I J|K L M|N O P|Q R S|T U V|W X Y|";
TCHAR Pad30[] = "            - |- A B|C D E|F G H|I J K|L M N|O P Q|R S T|U V W|X Y Z|";

TCHAR Pad31[] = "   To Encipher: Write in the plaintext message in the correct place on the";
TCHAR Pad32[] = "                One Time Pad. Find the plaintext letter in the top alphabet";
TCHAR Pad33[] = "                and the key letter in the side alphabet. Then trace down";
TCHAR Pad34[] = "                from the top and in from the side. The ciphertext letter";
TCHAR Pad35[] = "                stands at the intersection of the column and the row";
TCHAR Pad36[] = "                (i.e. plaintext 'M' and key letter 'W' equals ciphertext";
TCHAR Pad37[] = "                letter 'H'). Place the ciphertext letter in the correct";
TCHAR Pad38[] = "                place on the One Time Pad.";
TCHAR Pad39[] = "   To Decipher: Write in the ciphertext message in the correct place on";
TCHAR Pad40[] = "                the One Time Pad. Find the key letter in the side alphabet.";
TCHAR Pad41[] = "                Follow that row in until you find the ciphertext letter.";
TCHAR Pad42[] = "                Follow that column up to the plaintext alphabet at the";
TCHAR Pad43[] = "                top. This is your plaintext letter (i.e. key letter 'S'";
TCHAR Pad44[] = "                and ciphertext letter 'Z' equals plaintext letter 'H').";
TCHAR Pad45[] = "                Place the plaintext letter in the correct place on the";
TCHAR Pad46[] = "                One Time Pad.";

// Strings used to Make a One Time Pad.
//.....................................
TCHAR PadLine1[] = " Top Secret Crypto Gold       <<< One Time Pad >>>              Page xxx of xxx";
TCHAR PadLine2[] = " Pad ID:                                                        Copy   x of   2";
BYTE  PadLine3[] = " KEY:                                                                          ";
TCHAR PadLine4[] = " PLAIN:   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _";
TCHAR PadLine5[] = " CIPHER:  _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _   _ _ _ _ _";
TCHAR PadLine6[] = " PLAIN OR";
TCHAR OTPFileID[] = "OTPF";
TCHAR OTPFileHeader[] = "XXX";
TCHAR szFillOne[] = "<<< One Time Pad >>>";
TCHAR szFillTwo[] = "<<< Message Pad >>> ";

// Variables and constants for the printing procedures.
//.....................................................
BOOL		bAbortPrintJob;
HWND		hAbortPrintDlg = NULL;
TCHAR		szDocToPrint[64];
PRINTDLG	pd;
TCHAR		szPadID[51];
DWORD		dwPagesPerPad;
TCHAR		szNumberPad[7];

// Make a One Time Pad.
//.....................
BOOL MakeAOneTimePad()
{
	LPVOID		lpPadBuffer1 = 0;
	LPVOID		lpPadBufferDup1;		 
	LPVOID		lpPadBuffer2 = 0;
	BOOL		bResult = FALSE;
	int			iDlgResult;
	DWORD		dwPadSeed;
	DWORD		dwPageNumber;
	DWORD		GroupsPerPage;
	DWORD		dwNumbersWanted;
	DWORD		dwTestNumber;
	HDC			hDC = 0;
	HFONT		hFont = 0;
	DOCINFO		di;
	TEXTMETRIC	tm;		
	int			NewLineSpace;
	int			NextLine;
	int			iSavedDC;
	BOOL		bTextOutFailed = FALSE;
	DWORD		dwCopies;
	DWORD		dwPagesInPad;
	DWORD		dwOldHelpTopic;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change to the help topic for creating a One Time Pad.
	//......................................................
	dwOldHelpTopic = ChangeHelpTopic(IDH_MAKEONETIMEPAD);

	// Allocate the memory we need for our buffers.
	//.............................................
	lpPadBuffer1 = AllocateMemory(Goal*4);
	lpPadBuffer2 = AllocateMemory(Goal*4);
	if (!lpPadBuffer1 || !lpPadBuffer2)
	{
		goto CleanUp;
	}
	// Fill the buffer with random numbers.
	//.....................................
	dwNumbersWanted = Goal;
	lpPadBufferDup1 = lpPadBuffer1;
	StirTheBits();
	while(dwNumbersWanted > 0)
	{
		while(TRUE)
		{
			GetRandomBits(32,&dwTestNumber);
			if (dwTestNumber >= 100000001)
			{
				break;
			}
		}
		__asm
		{
			mov		edi,lpPadBufferDup1
			mov		eax,dwTestNumber
			stosd
			mov		lpPadBufferDup1,edi
		}
		EmptyTheMessageQue();
		dwNumbersWanted--;
	}
	// Copy the memory to lpPadBuffer2.
	//.................................
	CopyMemory(lpPadBuffer2,lpPadBuffer1,Goal*4);

	// Get the seed number for the pseudo random number generators.
	//.............................................................
	while(TRUE)
	{
		GetRandomBits(32,&Seed);
		if (Seed >= 100000001)
		{
			break;
		}
	}
	dwPadSeed = Seed;

	// Get a Pad ID string for the one time pad, and the number of
	// pages per pad.
	//............................................................
	ZeroMemory(szPadID,sizeof(szPadID));
	iDlgResult = DialogBox(hInst,TEXT("PADIDDLG"),hMainWindow,(DLGPROC)PadIDProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CleanUp;
	}

	if (iDlgResult == IDCANCEL)
	{
		goto CleanUp;
	}
	// Setup the name of the document we are goint to print.
	//......................................................
	StringCbCopy((LPTSTR)&szDocToPrint,sizeof(szDocToPrint),TEXT("One Time Pad"));

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Get a Device Context, DC, for the printer we are going to use.
	//...............................................................
	hDC = GetPrinterDC(hMainWindow,PD_HIDEPRINTTOFILE | PD_NOPAGENUMS | 
					   PD_RETURNDC | PD_ENABLEPRINTHOOK | PD_SHOWHELP |
					   PD_USEDEVMODECOPIESANDCOLLATE,1,1,1,1,1);

	// Return if no printer DC or we cancelled the print job..
	//........................................................
	if (!hDC)
	{
		goto CleanUp;
	}
	// Continue on with the print job. Create the abort dialog box.
	//.............................................................
	hAbortPrintDlg = CreateDialog(hInst,TEXT("ABORTPRINTDLG"),hMainWindow,
								 (DLGPROC)AbortPrintDlg);
	if (!hAbortPrintDlg)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CleanUp;
	}
	// Create the font we want to use.
	//................................
	hFont = CreateMyFont(hDC);

	if (!hFont)
	{
		goto CleanUp;
	}
	// Get the text metrics to determine line height.
	//...............................................
	GetTextMetrics(hDC,&tm);
	NewLineSpace = tm.tmHeight + tm.tmExternalLeading;

	// Setup the arrays for the pseudo random number generators.
	//..........................................................
	RingMask = -1;
	SetupArrays(lpPadBuffer1);
	Divisor1 = 27;
	dwCopies = 2;

	// Setup PadLine1 and 2.
	//......................
	__asm
	{
		mov		edi,offset PadLine2[71]
		mov		byte ptr [edi],31h
	}

	FillMemory(&PadLine2[9],lstrlen((LPCTSTR)szPadID),0x20);
	CopyMemory(&PadLine2[9],szPadID,lstrlen((LPCTSTR)szPadID));
	CopyMemory(&PadLine1[30],szFillOne,lstrlen((LPCTSTR)szFillOne));
	StringCbPrintf(szNumberPad,sizeof(szNumberPad),"%3d",dwPagesPerPad);
	CopyMemory(&PadLine1[76],szNumberPad,3);

	// Disable the main application window.
	//.....................................
	EnableWindow(hMainWindow,FALSE);

	// Set the abort procedure to handle messages for the abort dialog.
	//.................................................................
	if (SetAbortProc(hDC,(ABORTPROC)AbortPrintJob) == SP_ERROR)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SETABORTPROC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto CleanUp;
	}
	// Setup the DOCINFO structure and start the print job.
	//.....................................................
	di.cbSize = sizeof(DOCINFO);
	di.lpszDocName = TEXT("Pad Instructions");
	di.lpszOutput = NULL;
	di.fwType = 0;
	di.lpszDatatype = NULL;

	bAbortPrintJob = FALSE;
		
	if (StartDoc(hDC,&di) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto CleanUp;
	}

	iSavedDC = SaveDC(hDC);

	// Print the one time pads.
	//.........................
	while(dwCopies != 0)
	{
		dwPagesInPad = dwPagesPerPad;
		dwPageNumber = 1;

		while(dwPagesInPad != 0)
		{
			if (StartPage(hDC) <= 0)
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTPAGE,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto CleanUp;
			}
			// Initialize NextLine to 0.
			//.........................
			NextLine = 0;

			// Setup the page number.
			//.......................
			StringCbPrintf(szNumberPad,sizeof(szNumberPad),"%3d",dwPageNumber);
			CopyMemory(&PadLine1[69],szNumberPad,3);

			// Send the text output to the print spooler.
			//...........................................
			__try
			{
				NextLine += NewLineSpace * 4;
				TextOut(hDC,0,NextLine,(LPTSTR)&PadLine1,lstrlen(PadLine1));
				NextLine += NewLineSpace;
				TextOut(hDC,0,NextLine,(LPTSTR)&PadLine2,lstrlen(PadLine2));
				NextLine += NewLineSpace * 3;

				// Send 8 groups per page.
				//........................
				GroupsPerPage = 7;
				while(GroupsPerPage != 0)
				{
					FillPadLine();
					TextOut(hDC,0,NextLine,(LPTSTR)&PadLine3,lstrlen(PadLine3));
					NextLine += NewLineSpace * 2;
					TextOut(hDC,0,NextLine,(LPTSTR)&PadLine4,lstrlen(PadLine4));
					NextLine += NewLineSpace * 2;
					TextOut(hDC,0,NextLine,(LPTSTR)&PadLine5,lstrlen(PadLine4));
					NextLine += NewLineSpace * 3;
					GroupsPerPage--;
				}
			}
			__finally
			{
				// Display an error message if we have an 
				// abnormal termination.
				//.......................................
				if (AbnormalTermination())
				{
					MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_TEXTOUT,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
					bTextOutFailed = TRUE;
				}
			}
			// If any of the TextOut procedures failed we have to quit.
			//.........................................................
			if (bTextOutFailed)
				goto CleanUp;

			if (EndPage(hDC) <= 0)
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDPAGE,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto CleanUp;
			}

			// If we have aborted the print job, break out of the loop.
			//.........................................................
			if (bAbortPrintJob)
				break;

			// Start the next page.
			//.....................
			RestoreDC(hDC,iSavedDC);
			dwPageNumber++;
			dwPagesInPad--;
		}
		// If we have aborted the print job, break out of the loop.
		//.........................................................
		if (bAbortPrintJob)
			break;

		// Setup Copy 2 of 2.
		//...................
		__asm
		{
			mov		edi,offset PadLine2[71]
			mov		byte ptr [edi],32h
		}
		// Setup the original parameters to generate the 2nd copy.
		//........................................................
		Seed = dwPadSeed;
		CopyMemory(lpPadBuffer1,lpPadBuffer2,Goal*4);
		SetupArrays(lpPadBuffer1);
		Divisor1 = 27;
		dwPageNumber = 1;
		dwCopies--;
	}
	// Terminate the print job if we selected abort.
	//..............................................
	if (bAbortPrintJob)
	{
		AbortDoc(hDC);
		goto CleanUp;
	}
	// Setup and print the message pads.
	//..................................
	dwCopies = 2;
	CopyMemory(&PadLine1[30],szFillTwo,lstrlen((LPCTSTR)szFillOne));

	__asm
	{
		mov		edi,offset PadLine2[71]
		mov		byte ptr [edi],31h
	}

	while(dwCopies != 0)
	{
		dwPagesInPad = dwPagesPerPad;
		dwPageNumber = 1;

		while(dwPagesInPad != 0)
		{
			if (StartPage(hDC) <= 0)
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTPAGE,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto CleanUp;
			}
			// Initialize NextLine to 0.
			//.........................
			NextLine = 0;

			// Setup the page number.
			//.......................
			StringCbPrintf(szNumberPad,sizeof(szNumberPad),"%3d",dwPageNumber);
			CopyMemory(&PadLine1[69],szNumberPad,3);

			// Send the text output to the print spooler.
			//...........................................
			__try
			{
				NextLine += NewLineSpace * 4;			
				TextOut(hDC,0,NextLine,(LPTSTR)&PadLine1,lstrlen(PadLine1));
				NextLine += NewLineSpace;
				TextOut(hDC,0,NextLine,(LPTSTR)&PadLine2,lstrlen(PadLine2));
				NextLine += NewLineSpace * 6;

				// Send 8 groups per page.
				//........................
				GroupsPerPage = 7;
				while(GroupsPerPage != 0)
				{
					TextOut(hDC,0,NextLine,(LPTSTR)&PadLine6,lstrlen(PadLine6));
					NextLine += NewLineSpace;
					TextOut(hDC,0,NextLine,(LPTSTR)PadLine5,lstrlen(PadLine5));
					NextLine += NewLineSpace * 6;
					GroupsPerPage--;
				}
			}
			__finally
			{
				// Display an error message if we have an 
				// abnormal termination.
				//.......................................
				if (AbnormalTermination())
				{
					MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_TEXTOUT,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
					bTextOutFailed = TRUE;
				}
			}
			// If any of the TextOut procedures failed we have to quit.
			//.........................................................
			if (bTextOutFailed)
			{
				goto CleanUp;
			}

			if (EndPage(hDC) <= 0)
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDPAGE,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto CleanUp;
			}

			// If we have aborted the print job, break out of the loop.
			//.........................................................
			if (bAbortPrintJob)
			{
				break;
			}

			// Start the next page.
			//.....................
			RestoreDC(hDC,iSavedDC);
			dwPageNumber++;
			dwPagesInPad--;
		}
		// If we have aborted the print job, break out of the loop.
		//.........................................................
		if (bAbortPrintJob)
		{
			break;
		}

		// Setup Copy 2 of 2.
		//...................
		__asm
		{
			mov		edi,offset PadLine2[71]
			mov		byte ptr [edi],32h
		}

		// Do the second copy.
		//....................
		dwPageNumber = 1;
		dwCopies--;
	}
	if (EndDoc(hDC) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto CleanUp;
	}
	// We are done with our print job. Terminate the print job
	// if we selected abort, or else destroy our dialog box.
	//........................................................
	if (bAbortPrintJob)
	{
		AbortDoc(hDC);
	}
	else
	{
		DestroyWindow(hAbortPrintDlg);
	}
	// Clean up after our selves.
	//...........................
	CleanUp:

	FlashMyIcon(FALSE);

	if (lpPadBuffer1)
	{
		ZeroMemory(lpPadBuffer1,Goal*4);
		DeallocateMemory(lpPadBuffer1);
	}
	if (lpPadBuffer2)
	{
		ZeroMemory(lpPadBuffer2,Goal*4);
		DeallocateMemory(lpPadBuffer2);
	}
	if (pd.hDevMode)
	{
		GlobalFree(pd.hDevMode);
	}
	if (pd.hDevNames)
	{
		GlobalFree(pd.hDevNames);
	}
	if (hFont)
	{
		DeleteObject(hFont);
	}

	bProcessInProgress = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	EnableWindow(hMainWindow,TRUE);
	SetFocus(hMainWindow);
	
	if (hDC)
	{
		DeleteDC(hDC);
	}
	return(TRUE);
}

// CALLBACK procedure for the Pad ID dialog box.
//..............................................
LRESULT CALLBACK PadIDProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HWND hMyBuddy;
	HWND hSpinBox;
	DWORD dwStyle;
	BOOL bError;

	switch(uiMsg)
	{
		case (WM_INITDIALOG):
		{
			// Setup our spin box.
			//....................
			hMyBuddy = GetDlgItem(hDlg,IDC_BUDDY1);
			dwStyle = UDS_WRAP | UDS_ARROWKEYS | UDS_ALIGNRIGHT | UDS_SETBUDDYINT | UDS_NOTHOUSANDS;
			hSpinBox = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_PAGES,hMyBuddy,100,1,1);
			SendDlgItemMessage(hDlg,IDC_BUDDY1,EM_SETLIMITTEXT,(WPARAM) 3,0);
			SendDlgItemMessage(hDlg,IDC_PADID,EM_SETLIMITTEXT,(WPARAM) 50,0);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			if (!hSpinBox)
			{
				return(FALSE);
			}
			else
			{
				return(TRUE);
			}
		}

		case (WM_COMMAND):
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					GetDlgItemText(hDlg,IDC_PADID,szPadID,sizeof(szPadID)-1);
					dwPagesPerPad = GetDlgItemInt(hDlg,IDC_BUDDY1,&bError,FALSE);
					if (dwPagesPerPad == 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_ZEROPAGES,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY1));
						break;
					}

					if (lstrlen(szPadID) == 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_NOPADID,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_PADID));
						break;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Hook procedure for the GetOpenFileName, GetSaveFileName functions.
//...................................................................
UINT CALLBACK MyOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}
	}
	return(FALSE);
}

// Fill the pad line with randomly generated characters in the
// range A to Z and -, and put them in the key line.
//............................................................
VOID FillPadLine()
{
	LPBYTE lpPadLine = PadLine3;
	lpPadLine += 10;

	__asm
	{
		mov		edi,lpPadLine
		// 6 groups of 5 per line.
		//........................
		mov		ecx,6
	L1:	push	ecx
		// 5 letters per group.
		//.....................
		mov		ecx,5
	L2:	push	ecx
		push	edi
		call	GetRandomNumber
		// If the number returned is 0, make it a -,
		// or else make it a letter.
		//..........................................
		cmp		al,0h
		jne		L3
		mov		al,2dh
		jmp		L4
	L3:	add		al,40h
	L4:	pop		edi
		stosb
		add		di,1h
		pop		ecx
		loop	L2
		add		di,2h
		pop		ecx
		loop	L1
	}
}

// Print the One Time Pad Instructions.
//.....................................
BOOL PrintPadInstructions()
{
	HDC			hDC;
	HFONT		hFont;
	DOCINFO		di;
	TEXTMETRIC	tm;
	int			NewLineSpace;
	int			NextLine;
	DWORD		dwCopiesToPrint;
	int			iSavedDC;
	DWORD		dwOldHelpTopic;
	BOOL		bResult = FALSE;
	BOOL		bTextOutFailed = FALSE;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change to the help topic for printing One Time Pad Instructions.
	//.................................................................
	dwOldHelpTopic = ChangeHelpTopic(IDH_OTPINSTRUCTIONS);

	// Setup the name of the document we are goint to print.
	//......................................................
	StringCbCopy((LPTSTR)&szDocToPrint,sizeof(szDocToPrint),TEXT("One Time Pad Instructions"));

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Get a Device Context, DC, for the printer we are going to use.
	//...............................................................
	hDC = GetPrinterDC(hMainWindow,PD_HIDEPRINTTOFILE | PD_NOPAGENUMS | 
					   PD_RETURNDC | PD_ENABLEPRINTHOOK | PD_SHOWHELP,1,1,1,1,1);

	// Return if no printer DC or we cancelled the print job..
	//........................................................
	if (!hDC)
	{
		goto Error;
	}
	// Continue on with the print job. Create the abort dialog box.
	//.............................................................
	hAbortPrintDlg = CreateDialog(hInst,TEXT("ABORTPRINTDLG"),hMainWindow,
								 (DLGPROC)AbortPrintDlg);
	if (!hAbortPrintDlg)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto Error;
	}
	// Create the font we want to use.
	//................................
	hFont = CreateMyFont(hDC);

	if (!hFont)
	{
		goto Error;
	}
	// Get the text metrics to determine line height.
	//...............................................
	GetTextMetrics(hDC,&tm);
	NewLineSpace = tm.tmHeight + tm.tmExternalLeading;

	// Disable the main application window.
	//.....................................
	EnableWindow(hMainWindow,FALSE);

	// Set the abort procedure to handle messages for the abort dialog.
	//.................................................................
	if (SetAbortProc(hDC,(ABORTPROC)AbortPrintJob) == SP_ERROR)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SETABORTPROC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto Error;
	}
	// Setup the DOCINFO structure and start the print job.
	//.....................................................
	di.cbSize = sizeof(DOCINFO);
	di.lpszDocName = TEXT("Pad Instructions");
	di.lpszOutput = NULL;
	di.fwType = 0;
	di.lpszDatatype = NULL;

	bAbortPrintJob = FALSE;

	if (StartDoc(hDC,&di) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto Error;
	}
	iSavedDC = SaveDC(hDC);

	// Go into a loop and print the desired number of copies of
	// the pad instructions.
	//.........................................................
	dwCopiesToPrint = (WORD)pd.nCopies;
	while (dwCopiesToPrint != 0)
	{
		if (StartPage(hDC) <= 0)
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTPAGE,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto Error;
		}

		// Initialize NextLine to 0.
		//.........................
		NextLine = 0;

		// Send the text output to the print spooler.
		//...........................................
		__try
		{
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad1,lstrlen(Pad1));
			NextLine += NewLineSpace * 3;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad2,lstrlen(Pad2));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad4,lstrlen(Pad4));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad5,lstrlen(Pad5));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad6,lstrlen(Pad6));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad7,lstrlen(Pad7));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad8,lstrlen(Pad8));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad9,lstrlen(Pad9));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad10,lstrlen(Pad10));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad11,lstrlen(Pad11));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad12,lstrlen(Pad12));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad13,lstrlen(Pad13));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad14,lstrlen(Pad14));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad15,lstrlen(Pad15));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad16,lstrlen(Pad16));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad17,lstrlen(Pad17));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad18,lstrlen(Pad18));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad19,lstrlen(Pad19));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad20,lstrlen(Pad20));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad21,lstrlen(Pad21));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad22,lstrlen(Pad22));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad23,lstrlen(Pad23));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad24,lstrlen(Pad24));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad25,lstrlen(Pad25));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad26,lstrlen(Pad26));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad27,lstrlen(Pad27));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad28,lstrlen(Pad28));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad29,lstrlen(Pad29));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad30,lstrlen(Pad30));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad3,lstrlen(Pad3));

			// Print the encipher instructions for the table.
			//...............................................
			NextLine += (NewLineSpace *2);
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad31,lstrlen(Pad31));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad32,lstrlen(Pad32));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad33,lstrlen(Pad33));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad34,lstrlen(Pad34));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad35,lstrlen(Pad35));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad36,lstrlen(Pad36));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad37,lstrlen(Pad37));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad38,lstrlen(Pad38));

			// Print the decipher instructions for the table.
			//...............................................
			NextLine += (NewLineSpace *2);
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad39,lstrlen(Pad39));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad40,lstrlen(Pad40));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad41,lstrlen(Pad41));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad42,lstrlen(Pad42));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad43,lstrlen(Pad43));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad44,lstrlen(Pad44));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad45,lstrlen(Pad45));
			NextLine += NewLineSpace;
			TextOut(hDC,0,NextLine,(LPTSTR)&Pad46,lstrlen(Pad46));
		}
		__finally
		{
			// Display an error message if we have an 
			// abnormal termination.
			//.......................................
			if (AbnormalTermination())
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_TEXTOUT,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				bTextOutFailed = TRUE;
			}
		}
		// If any of the TextOut procedures failed we have to quit.
		//.........................................................
		if (bTextOutFailed)
		{
			goto Error;
		}

		if (EndPage(hDC) <= 0)
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDPAGE,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto Error;
		}
		// If we have aborted the print job, break out of the loop.
		//.........................................................
		if (bAbortPrintJob)
		{
			break;
		}
		// Continue on with the print job.
		//................................
		RestoreDC(hDC,iSavedDC);
		dwCopiesToPrint--;
	}
	// End the document.
	//..................
	if (EndDoc(hDC) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto Error;
	}
	// Terminate the print job if we selected abort, or else
	// destroy our dialog box.
	//......................................................
	if (bAbortPrintJob)
	{
		AbortDoc(hDC);
	}
	else
	{
		DestroyWindow(hAbortPrintDlg);
	}
	// We got through the print job without any errors.
	bResult = TRUE;

	// Handles normal and error termination.
	//......................................
	Error:

	FlashMyIcon(FALSE);

	if (pd.hDevMode)
	{
		GlobalFree(pd.hDevMode);
	}
	if (pd.hDevNames)
	{
		GlobalFree(pd.hDevNames);
	}
	if (hFont)
	{
		DeleteObject(hFont);
	}

	bProcessInProgress = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	EnableWindow(hMainWindow,TRUE);
	SetFocus(hMainWindow);
	if (hDC)
	{
		DeleteDC(hDC);
	}
	return(bResult);
}

// AbortPrintJob is the abort procedure for printing.
//..................................................
BOOL CALLBACK AbortPrintJob(HDC hdcPrinter, int Code)
{
	MSG msg;

	while (!bAbortPrintJob && PeekMessage(&msg,NULL,0,0,PM_REMOVE))
	{
		if (!TranslateAccelerator(hMainWindow,hAccel,&msg))
		{
			if (!IsDialogMessage(hAbortPrintDlg,&msg))
			{
				if (!HtmlHelp(NULL,NULL,HH_PRETRANSLATEMESSAGE,(DWORD)&msg))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
		}
	}
	// The abort argument is TRUE (return is FALSE)
	// if the user has cancelled the print operation.
	//...............................................
	return(!bAbortPrintJob);
}

// AbortPrintDlg handles messages for our Cancel Printing Dialog Box.
//...................................................................
LRESULT CALLBACK AbortPrintDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			// Center the dialog box and set the icon.
			//........................................
			SetMyIcon(hDlg);
			CenterWindow (hDlg,GetWindow(hDlg,GW_OWNER));

			// Sets the name of the document we are printing
			// in the dialog box we use to cancel printing.
			//..............................................
			SetDlgItemTextFmt(hDlg,IDC_PRINTJOB,(LPCTSTR)&szDocToPrint);
			ShowWindow(hDlg,SW_NORMAL);
			SetFocus(hDlg);
			UpdateWindow(hDlg);
			return(TRUE);
		}
		case WM_COMMAND:
		{
			// The cancel button was pressed.
			// Abort the document.
			//...............................
			if (LOWORD(wParam) == IDCANCEL)
			{
				bAbortPrintJob = TRUE;
				DestroyWindow(hDlg);
				return(TRUE);
			}
		}
		break;
	}
	return(FALSE);
}

// Setup and get a printer DC using the common dialog PrintDlg.
//.............................................................
HDC GetPrinterDC(HWND hWnd, DWORD dwFlags, DWORD dwFromPage,
				 DWORD dwToPage,DWORD dwMinPages, DWORD dwMaxPages, DWORD dwCopies)
{
	// Initialize the pd structure.
	//.............................
	ZeroMemory(&pd,sizeof(PRINTDLG));

	// Initialize the print dialog structure.
	//.......................................
	pd.lStructSize = sizeof(PRINTDLG);
	pd.hwndOwner = hWnd;
	pd.Flags = dwFlags;
	pd.nFromPage = LOWORD(dwFromPage);
	pd.nToPage = LOWORD(dwToPage);
	pd.nMaxPage = LOWORD(dwMaxPages);
	pd.nMinPage = LOWORD(dwMinPages);
	pd.nCopies = LOWORD(dwCopies);
	pd.hInstance = hInst;
	pd.lpfnPrintHook = PrtDlgHookProc;

	// Process the PrintDlg procedure.
	//................................
	if (!PrintDlg(&pd))
	{
		CommDlgBoxErrorProc(IDS_PRINT);
		pd.hDC = 0;
	}
	return(pd.hDC);
}

// Print common dialog box hook procedure.
//........................................
UINT CALLBACK PrtDlgHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			SetMyIcon(hDlg);
			CenterWindow(hDlg,hMainWindow);
			return(TRUE);
		}
		break;
	}
	return(FALSE);
}

// Create the font we will use for all of our printing in the program.
//....................................................................
HFONT CreateMyFont(HDC hDC)
{
	HFONT		hFont;
	int			iMapMode;
	UINT		uTextAlign;
	HGDIOBJ		hSelectObject;
	int			iHeight;

	iHeight = -((12 * GetDeviceCaps(hDC,LOGPIXELSY)) / 72);

	hFont = CreateFont(iHeight,0,0,0,FW_NORMAL,0,0,0,OEM_CHARSET,
		               OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
					   DEFAULT_QUALITY,FIXED_PITCH | FF_MODERN,"Terminal");

	iMapMode = SetMapMode(hDC,MM_TEXT);
	SetMapperFlags(hDC,1);
    hSelectObject = SelectObject(hDC,hFont);
	uTextAlign = SetTextAlign(hDC,TA_TOP | TA_LEFT);

	// Abort if we had an error in setting up the oem font.
	//.....................................................
	if (!hFont || !iMapMode || (uTextAlign == GDI_ERROR) || !hSelectObject)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SETFONTERROR,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		hFont = FALSE;
	}
	return(hFont);
}

HANDLE IsValidOTPKeyFile(LPTSTR lpFileName)
{
	HANDLE	hOTPKeyFile;
	DWORD	dwFileSizeLow;
	BOOL	bResult;
	DWORD	dwBytesRead;

	// Open the OTP Key File.
	//.......................
	hOTPKeyFile = CreateMyFile((LPTSTR)lpFileName,GENERIC_READ,0,NULL,
								OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOTPKeyFile)
		return(FALSE);

	// Read the file header.
	//......................
	bResult = ReadMyFile((LPTSTR)lpFileName,hOTPKeyFile,&OTPFileHeader,sizeof(OTPFileHeader),
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		CloseMyHandle((LPTSTR)lpFileName,hOTPKeyFile);
		return(FALSE);
	}
	// Get the size of the file and compare the header bytes.
	//.......................................................
	dwFileSizeLow = GetFileSize(hOTPKeyFile,NULL);

	if (CompareString(LOCALE_SYSTEM_DEFAULT,0,(LPCTSTR) &OTPFileID,
					  4,(LPCTSTR) &OTPFileHeader,4) != CSTR_EQUAL || 
					  (dwFileSizeLow != OTPFileSize))
	{
		SetLastError(IDS_NOTVALIDOTPKEYFILE);
		ErrorProcedure((LPTSTR)lpFileName,IDS_OTPKEYFILECHECK,MB_OK);
		CloseMyHandle((LPTSTR)lpFileName,hOTPKeyFile);
		return(FALSE);
	}
	return(hOTPKeyFile);
}
